state FireEntitySpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var permafrost_trap   								: W3PermafrostTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var icespear										: W3PermafrostSpear;
	var dummy											: CEntity;
	var dummy_proj                                      : W3PermafrostDummy;
	var vector_attach 									: Vector;
	var proj 											: W3MIgniGranade;
	
	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("monster_golem_ifryt.bnk") )
		{
			theSound.SoundLoadBank( "monster_golem_ifryt.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("monster_golem_dao.bnk") )
		{
			theSound.SoundLoadBank( "monster_golem_dao.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("monster_dracolizard.bnk") )
		{
			theSound.SoundLoadBank( "monster_dracolizard.bnk", false );
		}
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		//proc_precasting_stonewatcher();
		golem_fire_precast();
		cast_spells_axii_fireentity_init();
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{	
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_fireentity();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_fireentity();
			//parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private entry function golem_fire_precast()
	{
		var portal				: CEntity;
		var newPos				: Vector;
		
		if ( parent.spell_name == 'fire_golem' )
		{
			position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*2.5;
			position = find_position_spells( position );	
			if( !theGame.GetWorld().NavigationFindSafeSpot( position, 1, 1, newPos ) )
			{
				theGame.GetGuiManager().ShowNotification( GetLocStringByKeyExt( "menu_cannot_perform_action_here" ),, true );
				parent.GotoState( 'Vigil_Dreaming' );
			}
			else
			{
				Sleep(0.3);
				position.Z += 2;
				
				portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), position );
				portal.PlayEffect('teleport');
				portal.StopAllEffects();
				portal.DestroyAfter( 1.5 );
			}
		}
	}
	
	private function cast_spells_fireentity()
	{
		var fire_line 			: W3FireentityLine;
		var golem_npc 			: CNewNPC;
		var bonusAbilityName	: name;
		var pillar				: W3SpellsRockPillar;
	
		switch( parent.spell_name )
		{
			case 'fire_area':
				{
					thePlayer.SoundEvent("monster_golem_dao_cmb_swoosh_light");
				
					effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'fireentity_effects' ), thePlayer.GetWorldPosition() );
					effect_entity.PlayEffect( 'fireentity_pillar_ground' );
					effect_entity.DestroyAfter(5);
				
					actors = thePlayer.GetNPCsAndPlayersInRange( 7, 100, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors );
					for( i = 0; i < actors.Size(); i += 1 )
					{
						target = actors[i];
						effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'fireentity_effects' ), 
																		target.PredictWorldPosition( 0.2 ), target.GetWorldRotation() );
						effect_entity.PlayEffect( 'fireentity_pillar' );
						effect_entity.PlayEffect( 'fireentity_pillar_burn_sound' );
						effect_entity.StopEffect( 'fireentity_pillar_burn_sound' );
						effect_entity.SoundEvent("fx_fire_geralt_fire_hit");
						effect_entity.DestroyAfter(5);
						
						effect_entity = target.CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
						effect_entity.PlayEffect( 'flame' );
						effect_entity.DestroyAfter(5);
						
						theGame.GetSurfacePostFX().AddSurfacePostFXGroup( TraceFloor( target.PredictWorldPosition( 0.2 ) ), 0.5f, 3, 1.f, 2.f, 1);
						
						target.OnIgniHit( NULL );
						target.PlayEffect('fire_hit');
						
						damage_value = get_damage_value_for_cone_far( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitEffect('igni_cone_hit', false, false);
						damage_action.SetHitEffect('igni_cone_hit', true, false);
						damage_action.SetHitReactionType(EHRT_Igni, false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value );
						if( RandF() < 0.2 ) 
						{ 
							damage_action.AddEffectInfo( EET_Burning, 3 ); 
						}
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					parent.GotoState( 'Vigil_Dreaming' );
				}

				break;
			case 'fire_golem':
				{
					parent.destroy_fire_golems();
					
					duration = 15;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					position.Z -= 1;
					
					main_effect = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'golem_lvl2__ifryt' ), position, thePlayer.GetWorldRotation() );
					main_effect.AddTag( 'spells_fire_golem' );
					golem_npc = (CNewNPC)main_effect;
					golem_npc.AddTag( 'spells_fire_golem_npc' );
					golem_npc.SetAttitude( thePlayer, AIA_Friendly );
					
					bonusAbilityName = thePlayer.GetSkillAbilityName(S_Magic_s05);
					for(i=0; i<=3; i+=1)
					{
						golem_npc.AddAbility(bonusAbilityName, true);
					}
					parent.AddTimer( 'destroy_summoned_fire_golem', duration );
					parent.AddTimer( 'evaluate_targets_for_fire_golem', 0.3, true);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					
					parent.GotoState( 'Vigil_Dreaming' );
				}

				break;
			case 'fire_line':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\fireentity_fireline.w2ent";
					
			
					fire_line = (W3FireentityLine)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), position, rotation );
					fire_line.AddTag( 'spells_custom_projs' );
					fire_line.Init(NULL);
					fire_line.ShootProjectileAtPosition(0, 10, targetPosition, 20 );
					fire_line.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
					parent.GotoState( 'Vigil_Dreaming' );
				}
				
				break;
			default:		
				break;
		}
		
	}
	
	private entry function cast_spells_axii_fireentity_init()
	{
		if ( parent.spell_name == 'fireentity_projectile' )
		{
			parent.templatename = "dlc\magicspellsrev\data\entities\fireentity_projectile.w2ent";
			vector_attach = Vector( -0.2, 0.07, 0.05 );
			
			proj = (W3MIgniGranade)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), thePlayer.GetWorldPosition() );
			proj.AddTag( 'spells_custom_projs' );
			proj.AddTag( 'spells_from_sign' );
			proj.Init(NULL);
			proj.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
			proj.AddTimer( 'destroy_fireentity_proj', 0.5 );
		}
	}
	private function cast_spells_axii_fireentity()
	{
		if ( parent.spell_name == 'fireentity_projectile' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				
				targetPosition = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name( parent.actor ) );
				targetPosition.Z += 0.3;
			
				effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'fire_gnosis_effects' ), thePlayer.GetWorldPosition() ) ;
				effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				effect_entity.PlayEffect( 'fire_gnosis_shot' );
				effect_entity.DestroyAfter(3);
			
				proj.RemoveTimer( 'destroy_fireentity_proj' );
				proj.BreakAttachment();
				proj.ShootProjectileAtPosition(10, 10, targetPosition );
				
				proj.PlayEffect( 'fire_fx2' );
				proj.PlayEffect( 'fire_fx3' );
				proj.AddTimer('play_eff', 0.3);
				//proj.AddTimer('check_targets', 0.001, true);
				
				proj.DestroyAfter(10);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}